//
//  OTValueRecord.h
//  GSFontTools
//
//  Created by Martin Winter on 08/10/2019.
//  Copyright © 2019 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

@class GSXMLWriter;
@class OTDevice;
@class TTFont;

NS_ASSUME_NONNULL_BEGIN

@interface OTValueRecord : NSObject

@property (nonatomic, strong, nullable) OTDevice *xPlaDevice;
@property (nonatomic, strong, nullable) OTDevice *yPlaDevice;
@property (nonatomic, strong, nullable) OTDevice *xAdvDevice;
@property (nonatomic, strong, nullable) OTDevice *yAdvDevice;
@property (nonatomic) NSInteger xPlacement;
@property (nonatomic) NSInteger yPlacement;
@property (nonatomic) NSInteger xAdvance;
@property (nonatomic) NSInteger yAdvance;

- (void)toXML:(GSXMLWriter *)writer font:(TTFont *)font name:(NSString *)name attrs:(NSMutableArray *)attrs;

@end

NS_ASSUME_NONNULL_END
